<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="utf-8"/>

<xsl:template match="/MEREPORT">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
		<head>
			<title>Carriers</title>
			<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
			<link rel="stylesheet" type="text/css">
				<xsl:attribute name="href">
					<xsl:value-of select="csspath"/>
				</xsl:attribute>
			</link>
		</head>
		<body>
			<div id="content">		
				<h1>Carriers</h1>
				<xsl:call-template name="carriers"/>
			</div>
		</body>
	</html>
</xsl:template>

<xsl:template name="carriers">
	<table>
		<tr>
			<th>id</th>
			<th>name</th>
			<th>numeric</th>
			<th>mcc</th>
			<th>mnc</th>
			<th>apn</th>
			<th>user</th>
			<th>server</th>
			<th>password</th>
			<th>proxy</th>
			<th>port</th>
			<th>mmsproxy</th>
			<th>mmsport</th>
			<th>mmsc</th>
			<th>type</th>
			<th>current</th>
		</tr>
		
		<xsl:for-each select="carrier">
			<tr>
				<xsl:attribute name="class">
					<xsl:if test="position() mod 2 = 0">zebra1</xsl:if>
					<xsl:if test="position() mod 2 = 1">zebra2</xsl:if>
				</xsl:attribute>	
						
				<td><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@name"/></td>
				<td><xsl:value-of select="@numeric"/></td>
				<td><xsl:value-of select="@mcc"/></td>
				<td><xsl:value-of select="@mnc"/></td>
				<td><xsl:value-of select="@apn"/></td>
				<td><xsl:value-of select="@user"/></td>
				<td><xsl:value-of select="@server"/></td>
				<td><xsl:value-of select="@password"/></td>
				<td><xsl:value-of select="@proxy"/></td>
				<td><xsl:value-of select="@port"/></td>
				<td><xsl:value-of select="@mmsproxy"/></td>
				<td><xsl:value-of select="@mmsport"/></td>
				<td><xsl:value-of select="@mmsc"/></td>
				<td><xsl:value-of select="@type"/></td>
				<td><xsl:value-of select="@current"/></td>
			</tr>
		</xsl:for-each>
		
	</table>
</xsl:template>

</xsl:stylesheet>

